<?php

Class Order_page {
	protected static $instance;

	public function __construct() {
		if ( ! class_exists('Woocommerce') ) return;
		add_shortcode('tee_shop_order_detail', array( $this, 'order_html' ) );
	}

	public static function get_instance()  {
        if ( !isset( self::$instance) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function order_html() {
    	if ( isset($_GET['post'] ) ) return;
		$order_id = isset( $_GET['order'] ) ? $_GET['order'] : false;
		$authen   = isset( $_GET['authen'] ) ? $_GET['authen'] : false;

		if( $order_id ) {
			$order = new WC_Order( $order_id );
			$confirm = get_post_meta( $order_id, 'tee_shop_order_authen', true );	
			if ( $authen != $confirm ) {
				echo "Order doesn't exist or Your link is expired.";
				return;
			}
		} else {
			echo "Order doesn't exist or Your link is expired.";
			return;
		}

		$track = '';

		$line_items = $order->get_items( 'line_item' );
		
		$html = '<div class="tee-order-page"><div class="sb-order-status">';
			$html .= '<span class="logo__text heading-1"><span>View Your order</span> or back to <a href="' . home_url('/') . '">Home</a>'; 
			$html .= '</span>';
			
			// left

			$html .= '<div class="order-items">';
				// foreach( $obj->line_items as $item ) {
				// 	$P = new S_Product();
				// 	$wc_id = $P->get_wc_product_id( $order->store_name, $item->product_id );
				// 	$html .= '<div class="item">';
				// 		$html .= '<div class="product__image"><img src="' . get_the_post_thumbnail_url( $wc_id ) . '"><span class="quantity">' . $item->quantity . '</span></div>';
				// 		$html .= '<div class="product__desc"><span class="name"><a href="' . get_permalink( $wc_id ) . '">' . $item->name .  '</span></a></div>';
				// 		$html .= '<div class="product__total">' . $item->price . '$</div>';
				// 		$html .= '<div class="product__dc">' . $item->total_discount . '$</div>';
				// 	$html .= '</div>';
				// }
				// $html .= '<div class="item-total">'; 
				// 	$html .= '<span class="sub-total">Sub Total: <span>' . $obj->subtotal_price . '</span></span>';
				// 	$html .= '<span class="dc">Total discount: <span>' . $obj->total_discounts . '</span></span>';
				// 	$html .= '<span class="shipping">Shipping: <span>' . $obj->total_shipping_price_set->shop_money->amount . '</span></span>';
				// 	$html .= '<span class="total">Total: <span>' . $obj->total_price . '</span></span>';
					ob_start();
					foreach ( $line_items as $item_id => $item ) {
						echo '<div class="wc-item">';
						include 'order_item_html.php';
						echo '</div>';
					}
					$html .= ob_get_clean();
					$total = $order->get_order_item_totals();
					$html .= '<div class="item-total">'; 
						foreach( $total as $k => $v ) {
							$html .= '<div class="' . $k . '">' . $v['label'] . ' ' . $v['value'] . '</div>';
						}
					$html .= '</div>';// item-total
			$html .= '</div>'; //order-items;
			// right
			$html .= '<div class="order-info">';
				$html .= '<div class="order-name">Order #' . $order->get_order_number() ;
					$html .= '<span class="thanks">Thank you ' . $order->get_billing_first_name() . ' !</span>';
				$html .= '</div>';
				$html .= '<div class="text"><p>Your order is confirmed</p>
							<p>You’ll receive an email when your order is on its way.</p>
							</div>';
				$html .= '<div class="customer-info">';
					$html .= '<div class="left">';
						$html .= '<div class="contact"><h3>Contact information</h3>';
							$html .= '<span>' . $order->get_billing_email() . '</span>';
						$html .= '</div>';
					$html .= '</div>';
					$html .= '<div class="right">';
						$html .= '<div class="shipping-addr">';
							$html .= '<h3>Shipping Address</h3>';
							$html .= '<span class="f">' . $order->get_shipping_first_name() . '</span>';
							$html .= '<span class="l">' . $order->get_shipping_last_name() . '</span>';
							if ( $order->get_shipping_address_1() ) {
								$html .= '<span class="addr-1">' . $order->get_shipping_address_1() . '</span>';
							}
							$html .= '<span class="city">' . $order->get_shipping_city() . '</span>';
							$html .= '<span class="province">' . $order->get_shipping_state() . '</span>';
							$html .= '<span class="country">' . $order->get_shipping_country() . '</span>';
							if ( $order->get_shipping_address_2() ) {
								$html .= '<span class="addr-1">' . $order->get_shipping_address_2 . '</span>';
							}
						$html .= '</div>';
						$html .= '<div class="billing-addr">';
							$html .= '<h3>Billing Address</h3>';
							$html .= '<span class="f">' . $order->get_billing_first_name() . '</span>';
							$html .= '<span class="l">' . $order->get_billing_first_name() . '</span>';
							if ( $order->get_billing_address_1() ) {
								$html .= '<span class="addr-1">' . $order->get_billing_address_1() . '</span>';
							}
							$html .= '<span class="city">' . $order->get_billing_city() . '</span>';
							$html .= '<span class="province">' . $order->get_billing_state() . '</span>';
							$html .= '<span class="country">' . $order->get_billing_country() . '</span>';
							if ( $order->get_billing_address_2() ) {
								$html .= '<span class="addr-1">' . $order->get_billing_address_2() . '</span>';
							}
						$html .= '</div>';
					$html .= '</div>';
				$html .= '</div>';
				$html .= $track;
			$html .= '</div>';

			$html .= '<div class="clearfix"></div>';

		$html .= '</div></div>';


		return( $html );
    }  
}

Order_page::get_instance();
