
jQuery(document).ready(function(){
	var $ = jQuery;

	// Wait a bit for meta box to be fully loaded (especially for HPOS)
	setTimeout(function() {
		initTrackingScript();
	}, 100);
});

function initTrackingScript() {
	var $ = jQuery;

	var $template = $( 
		'<div class="track-information">' + 
			'<p><span class="notice-dismiss del-tracking"></span></p>' +
			'<p><label for="tee_tracking_number">Tracking Number</label><br />' + 
				'<input style="width: 100%" type="text" placeholder="Tracking Number" name="tee_tracking_number" class="tee_tracking_number"placeholder="" value="" />' + 
			'</p>' + 

			'<p>' +
				'<label for="order_tracking_link">Tracking URL</label>' +
				'<br />' +
				'<input style="width: 100%" placeholder="Tracking URL" type="text" class="order_tracking_link" name="order_tracking_link" value="" />' +
			'</p>' +

			'<div class="line-items">' +
			'</div>' +
		'</div>' );

	var 
		$tee_fulfill       = $('#teeAllover_fulfill'),
		$tee_total         = $('#tee_total_items'),
		$tee_total_fulfill = $('#tee_total_fulfill'),
		$wrap_trackings    = $('.tee-tracking'),
		$wrap              = $wrap_trackings.parent(),
		total_quantity     = 0,
		total_fulfill      = 0;

	// Check if required elements exist
	if( ! $wrap_trackings.length || ! $wrap.length ) {
		return;
	}

	$('#order_line_items .item').each(function(){
		var quantity = $(this).find('.quantity .view').clone();
		quantity.find('*').remove();
		quantity = quantity.text().replace( /\D*/g, '' );
		total_quantity += parseInt( quantity );
	});

	$wrap.find('.add-more .button').on('click',function(){
		var $tracking = $template.clone(),
			i = 1,
			$line_items = $('#order_line_items > .item');
		var $item_html = '';

		let items_ids = {};

		$line_items.each(function(){
			let item_id = $(this).attr('data-order_item_id');
			if( typeof items_ids[item_id] === 'undefined' ) {
				items_ids[item_id] = 1;
			} else {
				return;
			}
			var sku = $(this).find('.wc-order-item-sku').clone();
				quantity = $(this).find('.quantity .view').clone();
				sku.find('strong').remove();
				sku = ( sku.text().replace(/^\s|\s$/,'') );
				if( ! sku ) {
					sku = $(this).find('.wc-order-item-name').text();
				}
				quantity.find('*').remove();
				quantity = quantity.text().replace( /\D*/g, '' );
			$item_html += '<p class="item">' + i + '. ' + '<span class="item-sku">' + sku 
				+ '</span> x <input type="number" style="min-width: 57px;" class="item-quantity" value="' + quantity + '" min="0" max="' + quantity + '"></p>';
		});

		$tracking.find('input').on('change',function(){
			update_trackings();
		});

		$tracking.find('.del-tracking').on('click',function(){
			$(this).closest('.track-information').remove();
			update_trackings();
		});	

		$tracking.find('.line-items').append( $item_html );

		$wrap_trackings.append( $tracking );
	});

	$wrap_trackings.find('.del-tracking').on('click',function(){
		$(this).closest('.track-information').remove();
		update_trackings();
	});	

	$wrap_trackings.find('input').on('change',function(){
		update_trackings();
	});

	$('form#post').on('submit',function(e){
		update_trackings();
		if( total_fulfill > total_quantity ) {
			if( ! confirm( total_fulfill + ' Items Fulfill is over total items (' + total_quantity + ') of order. Continue Save ?') ) {
				e.preventDefault();
			}
		}
	});

	function update_trackings() {
		var data = {};
		total_fulfill = 0;
		$wrap_trackings.find('.track-information').each(function(){
			var tracking = {},
				total_tracking_item = 0;

			tracking.tracking_number = $(this).find('.tee_tracking_number').val();
			tracking.tracking_url = $(this).find('.order_tracking_link').val();
			tracking.line_items = {};

			$(this).find('.line-items .item').each(function(){
				var $item = {};
				$item.sku = $(this).find('.item-sku').text();
				if( $(this).find('input.item-quantity').length ) {
					$item.quantity = $(this).find('input.item-quantity').val();
				} else {
					$item.quantity = $(this).find('.item-quantity').text();
				}
				if ( $item.quantity ) {
					total_tracking_item += parseInt( $item.quantity );
					tracking.line_items[ $(this).index() ] = $item;
				}
			});

			if ( tracking.tracking_number && Object.keys( tracking['line_items'] ).length ) {
				data[$(this).index()] = tracking;
				total_fulfill += parseInt( total_tracking_item );
			}
		});


		$tee_total.val( total_quantity );
		$tee_total_fulfill.val( total_fulfill );
		$tee_fulfill.val( JSON.stringify( data ) );
	}

}