<?php if ( ! defined( 'ABSPATH' ) ) die( 'Forbidden' );
/**
 * Plugin Name: TeeAllover Mail
 * Plugin URI: http://teeallover.com/
 * Description: TeeAllover Mail, supports HPOS and legacy shop_order post type
 * Version: 1.5
 * Author: TeeAllover
 * Author URI: http://teeAllover.com
 * Text Domain: teeAllover
 */

include 'wc-tracking.php';
include 'Order_page.php';

add_theme_support( 'custom-logo' );

Class Tee_mail {
	protected static $instance;
	public $temp;

	public function __construct() {
		add_action( 'init', array( $this, 'register_post_type' ) );
		add_action( 'init', array( $this, 'init_mail_template' ) );

		add_action( 'admin_enqueue_scripts', array( $this, 'tee_mail_enqueue_script' ), 9999 );

		if( preg_match('/localhost/i', home_url() ) ) {
			add_action( 'admin_print_scripts', array( $this, 'print_script' ) );
		}

		add_action( 'after_setup_theme', array( $this, 'check_custom_logo' ), 99999 );
	}

	public static function get_instance()  {
        if ( !isset( self::$instance) ) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function check_custom_logo() {
    	if ( ! current_theme_supports('custom-logo') ) {
    		add_theme_support('custom-logo');
    	}
    }

	public function register_post_type() {
		
		$post_names = array(
			'singular' => __( 'Tee Mail', 'basr-core' ),
			'plural'   => __( 'Tee Mails ', 'basr-core' ),
			'name'     => __( 'Tee Mail', 'basr-core' ),
		);
		register_post_type(
			'tee_mail',
			array(
				'labels'             => array(
					'name'               => $post_names['name'],
					'singular_name'      => $post_names['singular'],
					'add_new'            => __( 'Add New', 'basr-core' ),
					'add_new_item'       => sprintf( __( 'Add New %s', 'basr-core' ), $post_names['singular'] ),
					'edit'               => __( 'Edit', 'basr-core' ),
					'edit_item'          => sprintf( __( 'Edit %s', 'basr-core' ), $post_names['singular'] ),
					'new_item'           => sprintf( __( 'New %s', 'basr-core' ), $post_names['singular'] ),
					// 'all_items'          => sprintf( __( 'All %s', 'basr-core' ), $post_names['plural'] ),
					'all_items'          => $post_names['name'],
					'view'               => sprintf( __( 'View %s', 'basr-core' ), $post_names['singular'] ),
					'view_item'          => sprintf( __( 'View %s', 'basr-core' ), $post_names['singular'] ),
					'search_items'       => sprintf( __( 'Search %s', 'basr-core' ), $post_names['plural'] ),
					'not_found'          => sprintf( __( 'No %s Found', 'basr-core' ), $post_names['plural'] ),
					'not_found_in_trash' => sprintf( __( 'No %s Found In Trash', 'basr-core' ), $post_names['plural'] ),
					'parent_item_colon'  => '' /* text for parent types */
				),
				'description'        => __( 'Create Mail Template', 'basr-core' ),
				'public'             => false,
				'show_ui'            => true,
				'show_in_menu'       => true,
				'publicly_queryable' => false,
				/* queries can be performed on the front end */
				'has_archive'        => false,
				// 'menu_icon'          => 'dashicons-grid-view',
				'hierarchical'       => true,
				'query_var'          => true,
				/* Sets the query_var key for this post type. Default: true - set to $post_type */
				'supports'           => array(
					'title' /* Text input field to create a post title. */,
					'editor',
				),
				'capabilities' => array(
					'edit_post'            => 'edit_pages', 
					'read_post'            => 'edit_pages', 
					'delete_post'          => 'edit_pages', 
					'delete_posts'         => 'edit_pages', 
					'edit_posts'           => 'edit_pages', 
					'edit_published_posts' => 'edit_pages', 
					'edit_others_posts'    => 'edit_pages', 
					'publish_posts'        => 'edit_pages',       
					'read_private_posts'   => 'edit_pages', 
					'edit_private_posts'   => 'edit_pages', 
					'create_posts'         => 'edit_pages', 
				),
			) 
		);

	}

	public function init_mail_template() {
		$status = get_option( 'mail_template_init', false );

		if( $status ) return;

		$content = '<table class="t-table">
			<tbody>
			<tr class="t-logo">
			<td class="shop-name__cell">{{obj.logo}}</td>
			</tr>
			<tr>
			<td class="no-padding">
				<h2 class="order-number__text">Your Order #{{obj.order_number}}</h2>
				<p class="p">Your shipping status has been updated!</p>
				<p class="p">Your tracking number: {{obj.trackings}}</p>
			</td>
			</tr>
			<tr>
			<td><a class="button__text" href="{{obj.order_url}}" target="_blank" rel="noopener noreferrer">View your order</a>
			or <a href="{{obj.site_url}}">Visit our store</a></td>
			</tr>
			</tbody><tfoot>
			    <tr>
			    	<td>
			    	<p class="p-1">Thanks for reading.</p>
			    	<p class="p-1">If you have any questions, please contact us at {{obj.admin_email}}</p>
			    	</td>
			    </tr>
			</tfoot>
			</table>';

		$args = array(
			'post_title'   => 'Update Tracking Number',
			'post_content' => $content,
			'post_status'  => 'publish',
			'post_type'    => 'tee_mail',
		);

		$id = wp_insert_post( $args );

		if( $id ) update_option( 'mail_template_init', true );
	}

	public function tee_mail_enqueue_script() {
		global $pagenow;

		$screen = get_current_screen();
		$is_order_screen = false;

		// Check for legacy shop_order post type (edit page)
		if( $pagenow == 'post.php' && get_post_type() == 'shop_order' ) {

			$is_order_screen = true;
		}
		
		// Check for legacy shop_order post type (listing page)
		if( $pagenow == 'edit.php' && isset( $_GET['post_type'] ) && $_GET['post_type'] == 'shop_order' ) {

			$is_order_screen = true;
		}
		
		// Check for HPOS order screen
		if( $screen && ( strpos( $screen->id, 'wc-orders' ) !== false || strpos( $screen->id, 'shop-order' ) !== false ) ) {

			$is_order_screen = true;
		}
		
		// Check for order edit page via GET parameters
		if( isset( $_GET['page'] ) && $_GET['page'] == 'wc-orders' && isset( $_GET['action'] ) && $_GET['action'] == 'edit' ) {

			$is_order_screen = true;
		}

		// Check for HPOS orders listing page
		if( isset( $_GET['page'] ) && $_GET['page'] == 'wc-orders' ) {

			$is_order_screen = true;
		}

		// Enqueue scripts and styles for order screens or settings page
		if( $is_order_screen || ( isset( $_GET['page'] ) && $_GET['page'] == 'tee-mail-setting' ) ) {

			wp_enqueue_style( 'tee-mail-css', plugins_url( 'assets/css/teeallover-mail.css' , __FILE__ ) );
			wp_enqueue_script( 'tee-mail-js', plugins_url( 'assets/js/script13.js' , __FILE__ ), array( 'jquery' ), '1.0.0', true );
		}
	}

	public function print_script() { ?>
		<script>
		document.write('<script src="http://' + (location.host || 'localhost').split(':')[0] +
		  ':35729/livereload.js?snipver=1"></' + 'script>')
		</script>
	<?php
	}

	public function get_template( $template_name ) {

		$template_id = get_option( 'teeAllover-mail_id' );

		if( ! $template_id ) {
			$template = get_posts( array( 'post_type' => 'tee_mail', 'posts_per_page' => 1 ) );
			if( $template ) {
				$template_id = $template[0]->ID;
				update_option( 'teeAllover-mail_id', $template_id );
			}
		}

		// get template by id 
		$template = get_post( $template_id );

		if( $template ) {
			return $template;
		}

		return false;
	}

	public function get_html_format( $msg, $title ) {
		$head = '<!DOCTYPE html><html lang="en"><head><title>' 
			. $title . '</title><meta http-equiv="Content-Type" content="text/html; charset=utf-8"><meta name="viewport" content="width=device-width"><style>' 
			. tee_mail_get_t_table_css() . '</style></head><body><div class="tee-wrap">';
		$foot = '</div></body></html>';

		return $head . $msg . $foot;
	}

	public function sent_mail( $template_name, $email, $obj, $header = '', $attachment = '' ) {

		$template 	  = $this->get_template( $template_name );
		if ( ! $template ) {
			// update notices 
			update_option( 'tee_mail_notices', " Sent Tracking To Customer Error: Mail template not found " , 'no' );
			return false;
		}

		$msg 		  = $template->post_content;

		$subject = $template->post_title;

		if( $template_name == 'Update Trackings Number') {
			$subject = $obj->site_title() . ' Update Trackings Number for order ' . $obj->order_number;
		}
		// l( $subject, 'subject' );

		$msg = $this->get_html_format( $msg, $subject );

		$msg = $this->fill_content( $msg, $obj );

		if ( $attachment ) {
			$rs = wp_mail( $email, $subject, $msg, $header, $attachment );	
		} else {
			$rs = wp_mail( $email, $subject, $msg );
		}

		return $rs;
	}

	public function fill_content( $msg, $obj ) {
		if ( ! is_object( $obj ) ) return $msg;
		$this->temp = $obj;
		$msg = preg_replace_callback( '/{{[^\}]*}}/', function( $matches ) {
			$str = preg_replace('/\s|\{|\}/', '',$matches[0]);
			$v = explode('.', $str );
			$k = count( $v ) > 1 ? 1 : 0;
			if ( isset( $this->temp->{$v[$k]} ) ) {
				return $this->temp->{$v[$k]};
			} else {
				return $matches[0];
			}
		}, $msg );
		return $msg;
	}

}

// add setting menu to plugin  

add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), '_tee_mail_link_page' );

function _tee_mail_link_page( $settings ) {
   $settings[] = '<a href="'. get_admin_url(null, '/edit.php?post_type=tee_mail&page=tee-mail-setting') .'">Settings</a>';
   return $settings;
}

Tee_mail::get_instance();

// Legacy shop_order post type columns
add_filter( 'manage_shop_order_posts_columns', 'add_shop_order_name_column', 9999, 1 );

function add_shop_order_name_column( $columns ) {
	$fulfill = array( 'fulfill' => 'Fulfill' );
	$first = $columns;
	array_splice( $first , 3, 9 );
	$first['fulfill'] = 'TeeAllover Fulfillment';
	$columns = $first + $columns;

	return $columns;
}

// HPOS (High-Performance Order Storage) columns support
if( function_exists( 'wc_get_page_screen_id' ) ) {

	$screen_id = wc_get_page_screen_id( 'shop-order' );
	add_filter( 'manage_' . $screen_id . '_columns', 'add_shop_order_name_column', 9999, 1 );
}

add_action( 'manage_shop_order_posts_custom_column' , 'shop_order_custom_column_name', 10, 2 );

// HPOS custom column action
if( function_exists( 'wc_get_page_screen_id' ) ) {

	$screen_id = wc_get_page_screen_id( 'shop-order' );
	add_action( 'manage_' . $screen_id . '_custom_column', 'shop_order_custom_column_name_hpos', 10, 2 );
}

function shop_order_custom_column_name( $column, $post_id ) {
	if ( get_post_type( $post_id ) == 'shop_order' && $column == 'fulfill' ) {
		// Use HPOS-compatible helper function if available, otherwise fallback to get_post_meta
		if( function_exists( 'tee_get_order_meta' ) ) {
			$fulfill = tee_get_order_meta( $post_id, 'tee_fulfill_status', true );
		} else {
			$fulfill = get_post_meta( $post_id, 'tee_fulfill_status', true );
		}
		if ( ! $fulfill || $fulfill == 'Unfulfilled' || $post_id != '4081' ) {
			$fulfill = tee_update_fulfill_status( $post_id );
		}
		echo '<span class="' . esc_attr( $fulfill ) . '">' . esc_html( $fulfill ) . '</span>';
	}
}

function shop_order_custom_column_name_hpos( $column, $order ) {
	if ( $column == 'fulfill' ) {
		$order_id = is_a( $order, 'WC_Order' ) ? $order->get_id() : intval( $order );
		$tracking = WC_Tracking::get_instance();
		$fulfill = $tracking->get_meta( $order_id, 'tee_fulfill_status', true );
		if ( ! $fulfill || $fulfill == 'Unfulfilled' ) {
			$fulfill = tee_update_fulfill_status( $order_id );
		}
		echo '<span class="' . esc_attr( $fulfill ) . '">' . esc_html( $fulfill ) . '</span>';
	}
}

function tee_update_fulfill_status( $post_id ) {

	// Use HPOS-compatible helper function if available, otherwise fallback to get_post_meta
	if( function_exists( 'tee_get_order_meta' ) ) {
		$trackings = tee_get_order_meta( $post_id, 'teeAllover_fulfill', true );
	} else {
		$trackings = get_post_meta( $post_id, 'teeAllover_fulfill', true );
	}
	
	if( $trackings ) {
		$trackings = json_decode( $trackings );
		$trackings = tee_convert_obj_to_array( $trackings );
	} else {
		$trackings = array();
	}

	$order = wc_get_order( $post_id ); 

	if( ! is_object( $order ) ) return 'N/A';

	$total = 0;

	// Iterating through each "line" items in the order
	foreach ($order->get_items() as $item_id => $item_data) {

	    // Get an instance of corresponding the WC_Product object
	    
	    $item_quantity = $item_data->get_quantity(); // Get the item quantity

	    $total += $item_data->get_quantity();
	}

	$ff = 0;

	if( count( $trackings ) ) {
		foreach( $trackings as $key => $item ) {
			if( isset( $item['line_items'] ) && is_array( $item['line_items'] ) && count( $item['line_items'] ) ) {
				foreach ($item['line_items'] as $k => $v) {
					$ff += $v['quantity'] ? $v['quantity'] : 0;
				}
			}
		}
	}
	$is_fulfill = 'Unfulfilled';
	if( $ff > 0 && $ff < $total ) $is_fulfill = 'Partially-Fulfilled';
	if( $ff > 0 && $ff >= $total ) $is_fulfill = 'Fulfilled';

	// Use HPOS-compatible helper function if available, otherwise fallback to update_post_meta
	if( function_exists( 'tee_update_order_meta' ) ) {
		tee_update_order_meta( $post_id, 'tee_fulfill_status', $is_fulfill );
		tee_update_order_meta( $post_id, 'tee_total_fulfill', $ff );
		tee_update_order_meta( $post_id, 'tee_total_items', $total );
	} else {
		update_post_meta( $post_id, 'tee_fulfill_status', $is_fulfill );
		update_post_meta( $post_id, 'tee_total_fulfill', $ff );
		update_post_meta( $post_id, 'tee_total_items', $total );
	}

	if( $is_fulfill == 'Fulfilled' && get_option( 'tee_to_complete' ) == 'true' ) {
		$order = new WC_Order( $post_id );
		if( is_object ( $order ) ) {
			$rs = $order->update_status( 'completed', 'order_note' ); 
		}
	}

	return  $is_fulfill;

}

function tee_mail_get_t_table_css() {
	$css  = '.tee-wrap {background: #f6f6f9;padding: 40px 15px;}';
	$css .= '.t-table{background:#fff;border:1px solid #d3d3d3;border-collapse:collapse;border-spacing:0;box-shadow:0 3px 5px rgba(0,0,0,.2);margin:60px auto;width:500px;text-align:center}.t-table>tr>td{border:none}.t-table table{border-collapse:collapse;border-spacing:0;margin-top:30px;margin-bottom:30px}.t-table table td{border:1px solid #d3d3d3}.t-table h2{background:#5c8708;color:#fff;font-weight:400;font-size:24px;margin:10px 0 40px;padding-top:20px;padding-bottom:20px;width:100%;text-align:center}.t-table td{padding:5px 15px}.t-table td:first-child{padding-left:30px}.t-table td:last-child{padding-right:30px}.t-table td p:first-child{margin-top:5px}.t-table td p:last-child{margin-bottom:5px}.t-table tfoot td{padding:40px 15px;text-align:center}.t-table .no-padding{padding:0}.t-table .t-left{float:left}.t-table .t-right{float:right}.t-table .t-center{margin-left:auto;margin-right:auto}.t-table .t-h{font-size:25px}.t-table .t-h span{font-weight:700}.t-table .t-100{width:100%}.t-table .t-logo{text-align:center}.t-table .t-logo td{padding:30px 60px}.t-table .t-logo img{margin:0 auto;max-width:150px}.t-table .t-head{text-align:center}.t-table .t-head td{background:#83bd31;color:#fff;font-size:20px;padding:20px 15px}.t-table .t-foot{text-align:center}.t-table .t-foot td{border-top:1px solid #d3d3d3;padding:20px 15px}.t-table .button__text{background:#5c8708;border-radius:5px;color:#fff;display:inline-block;font-size:16px;margin-top:20px;margin-bottom:20px;padding:20px 25px;text-decoration:none}';
	return $css;
}

if ( ! function_exists( 'tee_convert_obj_to_array' ) ) {
	function tee_convert_obj_to_array( $obj ) {
		if ( ! is_object( $obj ) && ! is_array( $obj )  ) return $obj;
		$obj = (array) $obj;
		foreach( $obj as $key => $value ) {
			if ( is_object( $value ) || is_array( $value ) ) {
				$obj[$key] = tee_convert_obj_to_array( $value );
			}
		}
		return $obj;
	}
}

add_action( 'admin_menu', 'tee_mail_register_setting_page' );

function tee_mail_register_setting_page(){
	global $submenu;
	global $menu;
    add_submenu_page(
        'edit.php?post_type=tee_mail',
        esc_html__( 'TeeMail Settings', 'teeallover' ),
        esc_html__( 'TeeMail Settings', 'teeallover' ),
        'manage_options',
        'tee-mail-setting',
        'tee_mail_setting' 
    );
}

function tee_mail_setting() {

	// check if current user can edit post 
	if ( ! current_user_can( 'edit_posts' ) ) return;

	if( isset( $_POST['to-complete'] ) ) {
		// validate  $_POST['default-tracking-url']
		$new_url = $_POST['default-tracking-url'];
		
		if( ! filter_var( $new_url, FILTER_VALIDATE_URL ) 
			|| ! preg_match( '/^https:\/\//i', $new_url ) 
			|| ! preg_match( '/{tracking_number}/', $new_url ) ) {
			echo "<p style='color: red'> Invalid Tracking Url</p>";
			if( ! preg_match( '/{tracking_number}/', $new_url ) ) {
				echo "<p style='color: red'> Tracking Url must contain {tracking_number} for tracking number input</p>";
			}
			return;
		}

		update_option( 'tee_to_complete', $_POST['to-complete'] ? 'true' : 'false', 'no' );
		update_option( 'teeAllover-mail_id', $_POST['default-mail-template'], 'no' );
		update_option( 'teeAllover-tracking-url', $_POST['default-tracking-url'], 'no' );
	}


	$template_id  = get_option( 'teeAllover-mail_id' );
	$tracking_url = get_option( 'teeAllover-tracking-url' );
	$tracking_url = $tracking_url ? $tracking_url : 'https://www.17track.net/en/track?nums={tracking_number}';

	// if null get first post from post_type tee_mail
	if(! $template_id ) {
		$template = get_posts( array( 'post_type' => 'tee_mail', 'posts_per_page' => 1 ) );
		if( $template ) {
			$template_id = $template[0]->ID;
			update_option( 'teeAllover-mail_id', $template_id );
		}
	}
	if( ! $template_id ) {
		echo "No Mail Template Found";
	}
	?>
	<h2>TeeAllover Tracking Settings</h2>
	<form id="tee-mail-settings-form" method="POST" action="<?php echo admin_url('/edit.php?post_type=tee_mail&page=tee-mail-setting') ?>">
		<p><input name="to-complete" <?php echo get_option( 'tee_to_complete' ) == 'true' ? 'checked' : ''; ?> type="checkbox">Change order status to Complete after TeeAllover Tracking <span style="color:blue;">Fulfilled</span></p>
		<p>
			<label>Tracking Mail Template</label>
			<!-- show all post from post_type tee mail for select -->
			<select name="default-mail-template">
				<option value="">Select</option>
				<?php
				$templates = get_posts( array( 'post_type' => 'tee_mail', 'posts_per_page' => -1 ) );
				foreach( $templates as $template ) {
					$selected  = $template_id == $template->ID ? 'selected' : '';
					echo "<option value='{$template->ID}' $selected>{$template->post_title}</option>";
				}
				?>
			</select>
		</p>
		<p>
			<label>Default Tracking Url for Tracking Number input without url</label>
			<input type="text" name="default-tracking-url" value="<?php echo $tracking_url?>">
		</p>
		<button type="submit" class="tee-save button button-primary">Save</button>
	</form>
	<style>
		#tee-mail-settings-form p { display: flex; align-items: center; flex-wrap: wrap;}
		#tee-mail-settings-form { width: 770px;padding: 15px;background-color: #fff;margin: 30px;}
		#tee-mail-settings-form label {display: inline-block; margin-right: 10px;}
		#tee-mail-settings-form input[type='checkbox'] { margin-right: 10px;}
		#tee-mail-settings-form input[type='text'] { width: 100%; margin-top: 10px;}
	</style>
	<?php
}

if ( ! function_exists( 'l' ) ) {
	function l( $param, $label = '' ) {
		// if ( ! get_current_user_id() == 1 ) return;
		$backtrace = debug_backtrace();
		$arr = explode( '/', $backtrace[0]['file'] );
		$last = count( $arr );
		error_log( $label . '_________________' . $arr[$last-3] . '/' . $arr[$last-2] . '/' . $arr[$last-1] . ':__________' . $backtrace[0]['line'] );
		error_log( print_r( $param, true ) );
	}
} 

if ( ! function_exists( 'lf' ) ) {
	
	function lf( $param, $label = '' ) {
		ob_start();
		if ( get_current_user_id() != 1 || ! function_exists('fw_print') ) return;
		$backtrace = debug_backtrace();
			fw_print( $backtrace[0]['file'] . ':__' . $backtrace[0]['line'] );
		if ( $label ) fw_print( $label  );
		fw_print( $param );
		echo ob_get_clean();
	}
}

if ( ! function_exists( 'f' ) ) {
	function f( $param, $label = '' ) {
		if ( ! function_exists('fw_print') ) return;
		fw_print( $param );
	}
}